/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.item;

import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightTags;
import com.renyigesai.immortalers_delight.potion.immortaleffects.StunEffect;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ImmortalersHammerItem
extends DiggerItem {
    protected final float attackDamage;
    protected final float attackSpeed;
    protected final float extra_attackDamage;
    protected final float extra_attackSpeed;
    protected int type_id;
    public static final int[] GIDDINESS_TIME = new int[]{16, 20, 24, 28, 32, 36, 40, 44};

    public ImmortalersHammerItem(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pAttackDamageModifier, pAttackSpeedModifier, pTier, ImmortalersDelightTags.MINEABLE_HAMMER, pProperties);
        this.attackDamage = pAttackDamageModifier + pTier.m_6631_();
        this.attackSpeed = pAttackSpeedModifier;
        this.extra_attackDamage = 0.0f;
        this.extra_attackSpeed = 0.0f;
    }

    public ImmortalersHammerItem(int type, Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, float pExtraAttackDamage, float pExtraAttackSpeed, Item.Properties pProperties) {
        super(pAttackDamageModifier, pAttackSpeedModifier, pTier, ImmortalersDelightTags.MINEABLE_HAMMER, pProperties);
        this.attackDamage = pAttackDamageModifier + pTier.m_6631_();
        this.attackSpeed = pAttackSpeedModifier;
        this.extra_attackDamage = pExtraAttackDamage;
        this.extra_attackSpeed = pExtraAttackSpeed;
        this.type_id = type;
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        float speed = super.m_8102_(pStack, pState);
        if (speed > 1.0f && pState.m_60734_().m_155943_() > (float)this.m_43314_().m_6604_()) {
            speed *= 0.5f;
        }
        return speed;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pLevel.f_46443_ || pState.m_60734_() == Blocks.f_50186_) {
            // empty if block
        }
        return super.m_6813_(pStack, pLevel, pState, pPos, pEntityLiving);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (stack.m_41720_() instanceof ImmortalersHammerItem) {
            MutableComponent textValue1 = Component.m_237115_((String)"tooltip.immortalers_delight.hammers_skill_title_1");
            MutableComponent textValue2 = Component.m_237115_((String)"tooltip.immortalers_delight.hammers_skill_title_2");
            if (Screen.m_96638_()) {
                MutableComponent textValueS1 = Component.m_237115_((String)"tooltip.immortalers_delight.hammers_skill_1");
                tooltip.add((Component)textValue1.m_130940_(ChatFormatting.YELLOW));
                tooltip.add((Component)textValueS1.m_130940_(ChatFormatting.GRAY));
                MutableComponent textValueS2 = Component.m_237115_((String)"tooltip.immortalers_delight.hammers_skill_2");
                tooltip.add((Component)textValue2.m_130940_(ChatFormatting.YELLOW));
                tooltip.add((Component)textValueS2.m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)textValue1.m_130940_(ChatFormatting.YELLOW));
                tooltip.add((Component)textValue2.m_130940_(ChatFormatting.YELLOW));
            }
        }
        super.m_7373_(stack, level, tooltip, isAdvanced);
    }

    @Mod.EventBusSubscriber(modid="immortalers_delight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ImmortalersHammerEvents {
        @SubscribeEvent
        public static void PlayerDizziness(AttackEntityEvent event) {
            Entity entity;
            if (event.getEntity() == null || event.getTarget() == null) {
                return;
            }
            if (!event.getEntity().m_9236_().m_5776_() && (entity = event.getTarget()) instanceof LivingEntity) {
                LivingEntity hurtOne = (LivingEntity)entity;
                Player attacker = event.getEntity();
                ItemStack toolStack = attacker.m_21120_(InteractionHand.MAIN_HAND);
                Item item = toolStack.m_41720_();
                if (item instanceof ImmortalersHammerItem) {
                    ImmortalersHammerItem hammer = (ImmortalersHammerItem)item;
                    float attackInterval = attacker.m_36403_(0.5f);
                    if (attackInterval >= 0.99f) {
                        StunEffect.applyImmortalEffect(hurtOne, GIDDINESS_TIME[hammer.m_43314_().m_6604_()], 0);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void VulnerableAndMobDizziness(LivingDamageEvent event) {
            LivingEntity attacker;
            Item item;
            Entity entity;
            if (event.getEntity() == null || event.getSource().m_7639_() == null) {
                return;
            }
            LivingEntity hurtOne = event.getEntity();
            if (!hurtOne.m_9236_().m_5776_() && (entity = event.getSource().m_7639_()) instanceof LivingEntity && (item = (attacker = (LivingEntity)entity).m_21205_().m_41720_()) instanceof ImmortalersHammerItem) {
                ImmortalersHammerItem hammer = (ImmortalersHammerItem)item;
                hurtOne.m_7292_(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.VULNERABLE.get(), GIDDINESS_TIME[hammer.m_43314_().m_6604_()] + 50, 1));
                if (StunEffect.getEntityMap().get(hurtOne.m_20148_()) != null || attacker instanceof Player) {
                    return;
                }
                float f = (float)GIDDINESS_TIME[hammer.m_43314_().m_6604_()] / 50.0f;
                if (attacker.m_217043_().m_188501_() < f) {
                    StunEffect.applyImmortalEffect(hurtOne, GIDDINESS_TIME[hammer.m_43314_().m_6604_()], 0);
                }
            }
        }

        @SubscribeEvent
        public static void onItemTooltip(ItemTooltipEvent event) {
            MutableComponent textValue;
            ItemStack stack = event.getItemStack();
            if (stack.m_204117_(ImmortalersDelightTags.IMMORTAL_KNIVES)) {
                textValue = Component.m_237115_((String)"tooltip.immortalers_delight.is_immortalers_knives");
                event.getToolTip().add(textValue.m_130940_(ChatFormatting.BLUE));
            }
            if (stack.m_204117_(ImmortalersDelightTags.IMMORTAL_HAMMERS)) {
                textValue = Component.m_237115_((String)"tooltip.immortalers_delight.is_immortalers_hammers");
                event.getToolTip().add(textValue.m_130940_(ChatFormatting.BLUE));
            }
            if (stack.m_204117_(ImmortalersDelightTags.STRAW)) {
                textValue = Component.m_237115_((String)"tooltip.immortalers_delight.is_straw");
                event.getToolTip().add(textValue.m_130940_(ChatFormatting.BLUE));
            }
        }
    }
}

